package gov.va.vinci.dart.db;

import java.util.List;

import gov.va.vinci.dart.biz.DocumentReviewNote;

public interface DocumentReviewNoteDAO {

	void save(final DocumentReviewNote note);
	DocumentReviewNote findById(final int documentId, final String createdBy);
	List<DocumentReviewNote> listByReviewerId(final String createdBy, final int documentId, final int groupId);
	List<DocumentReviewNote> listByGroupId(final int documentId, final int groupId);
	List<DocumentReviewNote> listByGroupIdForDocumentVersions(final int documentHeadId, final int groupId);
	int countDocumentVersions(final int documentHeadId, final int groupId);
//	List<DocumentReviewNote> listByGroupIdForRequestAndDocumentContent(final int requestId, final int documentId, final int contentId, final int groupId);
	Integer countNotesForActiveLocationDocsAndGroupId(final int requestHeadId, final int locationId, final int groupId);
	Integer countNotesForActiveParticipantDocsAndGroupId(final int requestHeadId, final int participantId, final int groupId);
}
